{********************************************
; File: Sound.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT SOUND;
INTERFACE
USES TYPES;
CONST

{ Error Codes }
noDOCFndErr = $0810;  { no DOC chip found }
docAddrRngErr = $0811;  { DOC address range error }
noSAppInitErr = $0812;  { no SAppInit call made }
invalGenNumErr = $0813;  { invalid generator number }
synthModeErr = $0814;  { synthesizer mode error }
genBusyErr = $0815;  { generator busy error }
mstrIRQNotAssgnErr = $0817;  { master IRQ not assigned }
sndAlreadyStrtErr = $0818;  { sound tools already started }
unclaimedSndIntErr = $08FF;  { sound tools already started }

{ channelGenMode Codes }
ffSynthMode = $0001;  { Free form synthesizer mode }
noteSynthMode = $0002;  { Note synthesizer mode. }

{ genMask Codes }
gen0off = $0001;  { param to FFStopSound }
gen1off = $0002;  { param to FFStopSound }
gen2off = $0004;  { param to FFStopSound }
gen3off = $0008;  { param to FFStopSound }
gen4off = $0010;  { param to FFStopSound }
gen5off = $0020;  { param to FFStopSound }
gen6off = $0040;  { param to FFStopSound }
gen7off = $0080;  { param to FFStopSound }
gen8off = $0100;  { param to FFStopSound }
gen9off = $0200;  { param to FFStopSound }
gen10off = $0400;  { param to FFStopSound }
gen11off = $0800;  { param to FFStopSound }
gen12off = $1000;  { param to FFStopSound }
gen13off = $2000;  { param to FFStopSound }
gen14off = $4000;  { param to FFStopSound }

{ genStatus Codes }
genAvail = $0000;  { Generator available status }
ffSynth = $0100;  { Free Form Synthesizer status }
noteSynth = $0200;  { Note Synthesizer status }
lastBlock = $8000;  { Last block of wave }

{ Jump Table Offsets }
smReadRegister = $00;  { Read Register routine }
smWriteRegister = $04;  { Write Register routine }
smReadRam = $08;  { Read Ram routine }
smWriteRam = $0C;  { Write Ram routine }
smReadNext = $10;  { Read Next routine }
smWriteNext = $14;  { Write Next routine }
smOscTable = $18;  { Pointer to Oscillator table }
smGenTable = $1C;  { Pointer to generator table }
smGcbAddrTable = $20;  { Pointer to GCB address table }
smDisableInc = $24;  { Disable Increment routine }
TYPE
SoundPBHndl = ^SoundPBPtr;
SoundPBPtr = ^SoundParamBlock;
SoundParamBlock = RECORD
    waveStart : Ptr; { starting address of wave }
    waveSize : Integer; { waveform size in pages }
    freqOffset : Integer; { ? formula to be provided }
    docBuffer : Integer; { DOC buffer start address, low byte = 0 }
    bufferSize : Integer; { DOC buffer start address, low byte = 0 }
    nextWavePtr : SoundPBPtr; { Pointer to start of next wave's parameter block }
    volSetting : Integer; { DOC volume setting. High byte = 0 }
END;
DocRegParamBlkPtr = ^DocRegParamBlk;
DocRegParamBlk = PACKED RECORD
    oscGenType : Integer;
    freqLow1 : Byte;
    freqHigh1 : Byte;
    vol1 : Byte;
    tablePtr1 : Byte;
    control1 : Byte;
    tableSize1 : Byte;
    freqLow2 : Byte;
    freqHigh2 : Byte;
    vol2 : Byte;
    tablePtr2 : Byte;
    control2 : Byte;
    tableSize2 : Byte;
END;
FUNCTION FFGeneratorStatus ( genNumber:Integer) : Integer ;
PROCEDURE FFSetUpSound ( channelGen:Integer; paramBlockPtr:SoundPBPtr)  ;
FUNCTION FFSoundDoneStatus ( genNumber:Integer) : Boolean ;
FUNCTION FFSoundStatus  : Integer ;
PROCEDURE FFStartPlaying ( genWord:Integer)  ;
PROCEDURE FFStartSound ( genNumFFSynth:Integer; pBlockPtr:SoundPBPtr)  ;
PROCEDURE FFStopSound ( genMask:Integer)  ;
FUNCTION GetSoundVolume ( genNumber:Integer) : Integer ;
FUNCTION GetTableAddress  : Ptr ;
PROCEDURE ReadDOCReg (VAR pBlockPtr:DocRegParamBlk)  ;
PROCEDURE ReadRamBlock ( destPtr:Ptr; docStart:Integer; byteCount:Integer)  ;
PROCEDURE SetDOCReg ( pBlockPtr:DocRegParamBlk)  ;
PROCEDURE SetSoundMIRQV ( sMasterIRQ:Longint)  ;
PROCEDURE SetSoundVolume ( volume:Integer; genNumber:Integer)  ;
FUNCTION  SetUserSoundIRQV ( userIRQVector:ProcPtr) : ProcPtr ;
PROCEDURE SoundBootInit   ;
PROCEDURE SoundReset   ;
PROCEDURE SoundShutDown   ;
PROCEDURE SoundStartUp ( dPageAddr:Integer)  ;
FUNCTION SoundToolStatus  : Boolean ;
FUNCTION SoundVersion  : Integer ;
PROCEDURE WriteRamBlock ( srcPtr:Ptr; docStart:Integer; byteCount:Integer)  ;
IMPLEMENTATION
END.
